local physics = {}

physics.force = require("physics.force")
physics.collider = require("physics.collider")
physics.particle = require("physics.particle")

function physics.update(colliders, dt)
    local forces = physics.force.forces
    for i = 1, #colliders do
        local c = colliders[i]

        if c.dormant then
            continue
        end

        for j = 1, #forces do
            forces[j]:apply(c)
        end

        c.velocity += c.force * dt
        c.rotation += c.inverse_inertia * c.torque * dt

        c.position += c.velocity * dt
        c.orientation += c.rotation * dt

        c.orientation = c.orientation:normalize()
        physics.collider.transformInertiaTensor(
                        c.orientation,
                        c.inverse_inertia,
                        physics.collider.calculateTransformMatrix(
                                                c.position,
                                                c.orientation
                                            )
                        )

        c.force.xyz = 0
        c.torque.xyz = 0
    end
    physics.collider.update(colliders, dt)
    for i = 1, #colliders do
        local c = colliders[i]

        -- put the collider to sleep if it's (almost) not moving
        if math.eq(c.velocity:length(), 0) and math.eq(c.force:length(), 0) then
            c.dormant = true
        end
    end
    local particles = physics.particle
    for i = 1, #particles do
        local p = particles[i]

        for j = 1, #forces do
            forces[j]:apply(p)
        end

        p.position += p.velocity * dt

        p.velocity += p.force * p.inverse_mass * dt

        p.velocity *= math.pow(p.damping, dt)

        p.force.xyz = 0
    end
end

return physics