local vector = require("util.geometry.vector")
local quaternion = require("util.geometry.quaternion")

local particle = {
    particles = {},
}

function particle.new(data)
    local self = {}

    for i, v in pairs(data) do
        self[i] = v
    end

    self.position = vector.from(self.position or { x = 0, y = 0, z = 0 })
    self.velocity = vector.from(self.velocity or { x = 0, y = 0, z = 0 })
    self.orientation = quaternion(self.orientation or { x = 0, y = 0, z = 0, w = 1 })
    self.scale = vector.from(self.scale or { x = 1, y = 1, z = 1 })
    self.mass = self.mass or self.scale:length()^3
    self.inverse_mass = 1 / self.mass
    self.friction = self.friction or 0.5
    self.force = vector.from(self.force or { x = 0, y = 0, z = 0 })
    self.damping = 0.5
    self.fluid = "air"

    if self.init then
        self:init()
    end

    particle.particles[#particle.particles + 1] = self

    return self
end

return particle