local vector = require("util.geometry.vector")
local quaternion = require("util.geometry.quaternion")

return function(collider)
    collider.register("cube", {
        distance = function(self, position)
            return self.position:distance(position) - self.scale
        end,
        collide = function(self, cube)
        end,
        ground = function(self, dt)
        end,
        forward_area = function(self)
            return math.pi * self.radius * self.radius
        end,
        drag_coeff = function(self, fluid)
            return 0.42
        end,
        friction = 0.2,
        elasticity = 0.9,
    })
end