local vector = import("memory.vector")
local color = require("util.gui.color")
local gui = import("gui")

ffi.cdef [[
    typedef struct {
        float x, y;
        float vx, vy;
        uint32_t color;
        float lifetime;
        float r;
        int mode;
    } particle;
]]

local circles = new "vector" "particle"
local squares = new "vector" "particle"
local lines = new "vector" "particle"

local function new(x, y, vx, vy, r, g, b, a, rad, lifetime, mode)
    if not mode or mode == 4 then
        mode = math.random(1, 3)
    end
    local v = {
        x = x,
        y = y,
        r = rad,
        vx = vx,
        vy = vy,
        color = color(r, g, b, a):get(),
        lifetime = lifetime,
        mode = mode,
    }
    if mode == 1 then
        vector.push_back(circles, v)
    elseif mode == 2 then
        vector.push_back(squares, v)
    elseif mode == 3 then
        vector.push_back(lines, v)
    end
end

local font = gui.make_font("Verdana")
local function draw()
    local count = circles.size + squares.size + lines.size
    local x = font:area(("%d particles"):format(count), 20)
    font:draw(("%d particles"):format(count), gui.width - x - 2, 24, 0xffffffff, 20)
    gui.no_stroke()
    if tonumber(circles.size) > 0 then
        local data = vector.data(circles)
        for i = 0, tonumber(circles.size) - 1 do
            local p = data[i]
            gui.fill(p.color)
            gui.circle(p.x, p.y, p.r)
        end
    end
    if tonumber(squares.size) > 0 then
        local data = vector.data(squares)
        for i = 0, tonumber(squares.size) - 1 do
            local p = data[i]
            gui.fill(p.color)
            gui.rectangle(p.x, p.y, p.r, p.r)
        end
    end
    if tonumber(lines.size) > 0 then
        local data = vector.data(lines)
        for i = 0, tonumber(lines.size) - 1 do
            local p = data[i]
            gui.stroke(p.color)
            gui.line(p.x, p.y, p.x + p.vx * p.r / 10, p.y + p.vy * p.r / 10)
        end
    end
end

local dt
local function pred(p)
    p.x += p.vx * dt
    p.y += p.vy * dt
    p.lifetime -= dt
    return p.lifetime <= 0
end

local function update(_dt)
    dt = _dt
    vector.erase_if(circles, pred)
    vector.erase_if(squares, pred)
    vector.erase_if(lines, pred)
end

return {
    new = new,
    draw = draw,
    update = update,
}