local ffi = require("ffi")

local kernel32 = ffi.load"kernel32";
local user32 = ffi.load"user32";
local gdi32 = ffi.load"gdi32";

ffi.cdef[[
    typedef long HRESULT;
    typedef void *HANDLE;
    typedef void *LPVOID;
    typedef HANDLE HMODULE;
    typedef HANDLE HWND;
    typedef HANDLE HINSTANCE;
    typedef HANDLE HICON;
    typedef HICON HCURSOR;
    typedef HANDLE HBRUSH;
    typedef HANDLE HMENU;
    typedef HANDLE HMONITOR;
    typedef unsigned char BYTE;
    typedef unsigned int UINT,*PUINT,*LPUINT;
    typedef __int64 INT_PTR, *PINT_PTR;
    typedef unsigned __int64 UINT_PTR, *PUINT_PTR;
    typedef __int64 LONG_PTR, *PLONG_PTR;
    typedef unsigned __int64 ULONG_PTR, *PULONG_PTR;
    typedef UINT_PTR WPARAM;
    typedef LONG_PTR LPARAM;
    typedef LONG_PTR LRESULT;
    typedef unsigned long DWORD;
    typedef int WINBOOL,*PWINBOOL,*LPWINBOOL;
    typedef WINBOOL BOOL;
    typedef long LONG;
    typedef char CHAR;
    typedef const CHAR *LPCCH,*PCSTR,*LPCSTR;
    typedef unsigned short WORD;
    typedef struct tagRECT {
    LONG left;
    LONG top;
    LONG right;
    LONG bottom;
    } RECT,*PRECT,*LPRECT;
    typedef RECT *NPRECT,*LPNRECT;
    typedef const RECT *LPCRECT;
    typedef HANDLE HDC;
    typedef struct tagPAINTSTRUCT {
    HDC	hdc;
    BOOL fErase;
    RECT rcPaint;
    BOOL fRestore;
    BOOL fIncUpdate;
    BYTE rgbReserved[32];
    } PAINTSTRUCT,*LPPAINTSTRUCT;
    typedef struct tagMONITORINFO {
    DWORD cbSize;
    RECT rcMonitor;
    RECT rcWork;
    DWORD dwFlags;
    } MONITORINFO,*LPMONITORINFO;
    typedef struct tagMONITORINFOEXA {
    MONITORINFO;
    CHAR szDevice[32];
    } MONITORINFOEXA,*LPMONITORINFOEXA;
    typedef MONITORINFOEXA MONITORINFOEX;
    typedef LPMONITORINFOEXA LPMONITORINFOEX;
    typedef struct tagDISPLAY_DEVICEA {
    DWORD cb;
    CHAR DeviceName[32];
    CHAR DeviceString[128];
    DWORD StateFlags;
    CHAR DeviceID[128];
    CHAR DeviceKey[128];
    } DISPLAY_DEVICEA,*PDISPLAY_DEVICEA,*LPDISPLAY_DEVICEA;
    typedef DISPLAY_DEVICEA DISPLAY_DEVICE,*PDISPLAY_DEVICE,*LPDISPLAY_DEVICE;
    typedef BOOL(*MONITORENUMPROC)(HMONITOR,HDC,LPRECT,LPARAM);
    BOOL EnumDisplayMonitors(HDC,LPCRECT,MONITORENUMPROC,LPARAM);
    int GetLastError(void);
    BOOL GetMonitorInfoA(HMONITOR,LPMONITORINFO);
    typedef struct _SECURITY_ATTRIBUTES {
        DWORD nLength;
        LPVOID lpSecurityDescriptor;
        BOOL bInheritHandle;
    } SECURITY_ATTRIBUTES, *PSECURITY_ATTRIBUTES, *LPSECURITY_ATTRIBUTES;
    BOOL CreateDirectoryA(LPCSTR,LPSECURITY_ATTRIBUTES);
    int GetTickCount(void);
    void PostQuitMessage(int);
    BOOL DeleteFileA(LPCSTR);
]]

local monitors = {}
local fn = ffi.cast("MONITORENUMPROC", function(hMonitor, hdcMonitor, lprcMonitor, dwData)
    local monitor = {
        x = lprcMonitor[0].left,
        y = lprcMonitor[0].top,
        w = lprcMonitor[0].right - lprcMonitor[0].left,
        h = lprcMonitor[0].bottom - lprcMonitor[0].top
    }
    monitor.hMonitor = hMonitor
    monitor.hdcMonitor = hdcMonitor
    monitor.lprcMonitor = lprcMonitor
    monitor.dwData = dwData
    local info = ffi.new("MONITORINFOEXA[1]")
    info[0].cbSize = ffi.sizeof("MONITORINFOEXA")
    user32.GetMonitorInfoA(monitor.hMonitor, ffi.cast("LPMONITORINFO", info))
    monitor.name = ffi.string(info[0].szDevice)
    table.insert(monitors, monitor)
    return 1
end)
user32.EnumDisplayMonitors(nil, nil, fn, ffi.cast("LPARAM", 0))
table.sort(monitors, function(a, b)
    return a.x < b.x
end)
for i = 1, #monitors do
    monitors[i].index = i
end
for i = 1, #monitors do
    local monitor = monitors[i]
    if monitor.x == 0 and monitor.y == 0 then
        monitors.primary = monitor
        monitors.index = i
        break
    end
end
monitors.index = monitors.index or 1
return monitors