import("util")
local gui = import("gui")
local events = require("util.common.events")
ENUMS = require("util.common.enums")

local stub = {
    fontID = nil,
    scale = 1,
    Width = gui.width,
    Height = gui.height,
    fontHeight = 100,
}
events.window_size_changed += function(w, h)
    stub.Width = w
    stub.Height = h
end
events.new("clicked")
events.initialize += function()
    stub.Width = gui.width
    stub.Height = gui.height
end

stub.clicked = function(self)
    events.clicked(self)
end

local function getfont()
    if not stub.font then
        stub.font = gui.make_font("Verdana")
        if not stub.font then
            error("Failed to load font")
        end
        local samplex, sampley = stub.font:area("ABCDEFGHIJKLMNOPRSTUVWXYZabcdefhiklmnorstuvwxz0123456789")
        stub.fontHeight = sampley
    end
    return stub.font
end

local sprites = {}
local function getsprite(path)
    if not sprites[path] then
        sprites[path] = gui.make_sprite(path)
    end
    return sprites[path]
end

function stub.DrawRectangle(x, y, width, height, color)
	gui.no_stroke()
	gui.fill(color)
    gui.rectangle(x, y, width, height)
end

function stub.DrawClippedRectangle(x, y, width, height, color, rect)
	gui.no_stroke()
	gui.fill(color)
    if x > rect.x + rect.width or x + width < rect.x or y > rect.y + rect.height or y + height < rect.y then
        return
    elseif x + width <= rect.x + rect.width and y + height <= rect.y + rect.height and x >= rect.x and y >= rect.y then
        gui.rectangle(x, y, width, height)
        return
    end
    local dx = 0
    local dy = 0
    local dw = width
    local dh = height
    if x < rect.x then
        dx = rect.x - x
        dw -= dx
        x = rect.x
    end
    if y < rect.y then
        dy = rect.y - y
        dh -= dy
        y = rect.y
    end
    if x + dw > rect.x + rect.width then
        dw = rect.x + rect.width - x
    end
    if y + dh > rect.y + rect.height then
        dh = rect.y + rect.height - y
    end
    gui.rectangle(x, y, dw, dh)
end

function stub.DrawRectangleOutline(x, y, width, height, color1, color2, thickness)
	gui.fill(color1)
	gui.stroke(color2)
	gui.stroke_weight(thickness)
    gui.rectangle(x, y, width, height)
end

function stub.DrawLine(x1, y1, x2, y2, color)
	gui.stroke(color)
    gui.line(x1, y1, x2, y2)
end

function stub.DrawText(text, size, x, y, color, font)
    (font or getfont()):draw(text, x, y, color, size)
end

function stub.DrawTextCentered(text, size, x, y, color, font)
    local f = font or getfont()
    local w, h = f:area(text, size)
    f:draw(text, x - w / 2, y - h / 2, color, size)
end

function stub.TextSize(text, size, font)
    local sx, sy = (font or getfont()):area(text, size)
    return sx, stub.fontHeight * size / 100
end

function stub.LoadImage(img)
    return getsprite(img)
end

function stub.DrawImage(img, x, y, w, h, c)
    if img then
        img:draw(x, y, w, h, c or -1)
    end
end

function stub.DrawCutImage(img, x, y, w, h, c, rect)
    if img then
        if x > rect.x + rect.width or x + w < rect.x or y > rect.y + rect.height or y + h < rect.y then
            return
        elseif x + w <= rect.x + rect.width and y + h <= rect.y + rect.height and x >= rect.x and y >= rect.y then
            img:draw(x, y, w, h, c or -1)
            return
        end
        local dx = 0
        local dy = 0
        local dw = w
        local dh = h
        if x < rect.x then
            dx = rect.x - x
            dw -= dx
            x = rect.x
        end
        if y < rect.y then
            dy = rect.y - y
            dh -= dy
            y = rect.y
        end
        if x + dw > rect.x + rect.width then
            dw = rect.x + rect.width - x
        end
        if y + dh > rect.y + rect.height then
            dh = rect.y + rect.height - y
        end
        local s = img.info
        img:draw(x, y, dw, dh, dx, dy, dw * s.width / w, dh * s.height / h, c or -1)
    end
end

function stub.DrawImageCentered(img, x, y, w, h, c)
    if img then
        local s = img.info
        img.origin = { x = s.width / 2, y = s.height / 2 }
        img:draw(x, y, w, h, c or -1)
    end
end

function stub.GetImageSize(img)
    if img then
        local s = img.info
        return s.width, s.height
    else
        return 0, 0
    end
end

function stub.DrawCircle(x, y, radius, color)
    gui.no_stroke()
    gui.fill(color)
    gui.circle(x, y, radius)
end

function stub.DrawCircleOutline(x, y, radius, color1, color2, thickness)
    gui.fill(color1)
    gui.stroke(color2)
    gui.stroke_weight(thickness)
    gui.circle(x, y, radius)
end

function stub.DrawTriangle(x1, y1, x2, y2, x3, y3, color)
    gui.no_stroke()
    gui.fill(color)
    gui.triangle(x1, y1, x2, y2, x3, y3)
end

function stub.background(color)
    gui.background(color)
end

return stub