---@class Text : BaseElement
local Text = require("util.common.Class")("Text", require("lml.BaseElement"))
local stub = require("lml.stub")
local Style = require("lml.Style")

function Text:__init(data)
    self.alt = data.alt or false    ; data.alt = nil
    self.height = data.height or "auto" ; data.height = nil ; self:fmt("height")
    self.sizes = data.sizes or "" ; data.sizes = nil
    self.src = data.src or "" ; data.src = nil
    self.usemap = data.usemap or "" ; data.usemap = nil
    self.width = data.width or "auto" ; data.width = nil ; self:fmt("width")
    self.text = data.text or "" ; data.text = nil
    self:__super(data)
    self.type = "Text"
end

function Text:Draw(data)
    self.style:DrawText(data.x + self.content.x, data.y + self.content.y, self.text)
    self.__super.Draw(self, data)
end

function Text:CalcSize()
    local tx, ty = stub.TextSize(self.text, self.style.font_size)
    self.client.width = tx
    self.client.height = ty
    self.style:FinalizeSize(self)
end

return Text