---@class Image : BaseElement
local Image = require("util.common.Class")("Image", require("lml.BaseElement"))
local stub = require("lml.stub")
local Style = require("lml.Style")

function Image:__init(data)
    self.alt = data.alt or false    ; data.alt = nil
    self.height = data.height or "auto" ; data.height = nil ; self:fmt("height")
    self.sizes = data.sizes or "" ; data.sizes = nil
    self.src = data.src or "" ; data.src = nil
    self.usemap = data.usemap or "" ; data.usemap = nil
    self.width = data.width or "auto" ; data.width = nil ; self:fmt("width")
    self:__super(data)
    self.type = "Image"
end

function Image:load()
    if self.src ~= "" then
        self.img = stub.LoadImage(self.src)
    end
end

function Image:Update()
    if not self.img then
        self:load()
        if self.img then
            if self.events.load then
                self.events:load()
            end
        end
    end
end

function Image:Draw(data)
    stub.DrawCutImage(self.img, data.x + self.content.x, data.y + self.content.y, self.content.width, self.content.height, self.style.opacity, data.client)
    self.__super.Draw(self, data)
end

function Image:CalcSize()
    local iw, ih = stub.GetImageSize(self.img)
    if type(self.width) == "string" then
        if self.parent then
            self.client.width = self.parent.content.width * ~self.width
        else
            self.client.width = iw * ~self.width
        end
    else
        self.client.width = self.width
    end
    if self.height == "auto" then
        self.client.height = self.client.width * ih / iw
    elseif type(self.height) == "string" then
        if self.parent then
            self.client.height = self.parent.content.width * ~self.height
        else
            self.client.height = ih * ~self.height
        end
    else
        self.client.height = self.height
    end
    self.style:FinalizeSize(self)
end

return Image