---@class Div : BaseElement
local Div = require("util.common.Class")("Div", require("lml.BaseElement"))
local stub = require("lml.stub")
local Style = require("lml.Style")

function Div:__init(data)
    self.alt = data.alt or false    ; data.alt = nil
    self.height = data.height or "auto" ; data.height = nil ; self:fmt("height")
    self.sizes = data.sizes or "" ; data.sizes = nil
    self.src = data.src or "" ; data.src = nil
    self.usemap = data.usemap or "" ; data.usemap = nil
    self.width = data.width or "auto" ; data.width = nil ; self:fmt("width")
    self:__super(data)
    self.type = "Div"
end

function Div:Update(...)
    for _, v in ipairs(self.children) do
        v:Update(...)
    end
    for _, v in ipairs(self.children) do
        v:CalcSize()
    end
end

function Div:PreDraw(data)
    if data.x > data.client.x then
        data.x = data.client.x
        data.y += data.height
        data.height = data.document.row_height
    end
    --self.style:DebugDraw(self)
    self.style:PreDraw(data, self.client)
    data.x += self.content.x
    data.y += self.content.y
    for _, v in ipairs(self.children) do
        v:PreDraw(data)
    end
end

function Div:Draw(data)
    data.x = data.client.x
    data.x += self.content.x
    for _, v in ipairs(self.children) do
        v:Draw(data)
    end
end

function Div:PostDraw(data)
    data.x = data.client.x
    data.x += self.content.x
    for _, v in ipairs(self.children) do
        v:PostDraw(data)
    end
    self.style:PostDraw(data, self.client)
    if data.x > data.client.x then
        data.x = data.client.x
        data.y += data.height + self.style.margin.bottom + self.style.padding.bottom + self.style.border.width
        data.height = data.document.row_height
    end
end

function Div:WndProc(data, mouse, msg, wparam, lparam)
    if data.x > data.client.x then
        data.x = data.client.x
        data.y += data.height
        data.height = data.document.row_height
    end
    data.x = data.client.x
    data.x += self.content.x
    data.y += self.content.y
    if self.__super.WndProc(self, data, mouse, msg, wparam, lparam) then
        return true
    end
    if data.x > data.client.x then
        data.x = data.client.x
        data.y += data.height
        data.height = data.document.row_height
    end
end

function Div:CalcSize()
    if self.parent then
        if type(self.width) == "string" then
            self.client.width = self.parent.client.width * ~self.width
        else
            self.client.width = self.width
        end
        if type(self.height) == "string" then
            self.client.height = self.parent.client.height * ~self.height
        else
            self.client.height = self.height
        end
    else
        if type(self.width) == "string" then
            self.client.width = stub.Width * ~self.width
        else
            self.client.width = self.width
        end
        if type(self.height) == "string" then
            self.client.height = stub.Height * ~self.height
        else
            self.client.height = self.height
        end
    end
    if self.width == "auto" then
        local required_width = 0
        for _, v in ipairs(self.children) do
            required_width = required_width + v.client.width
        end
        self.client.width = required_width
    end
    if self.height == "auto" then
        local required_height = 0
        for _, v in ipairs(self.children) do
            required_height = math.max(required_height, v.client.height)
        end
        self.client.height = required_height
    end
    self.style:FinalizeSize(self)
end

return Div