---@class CheckBox : BaseElement
local CheckBox = require("util.common.Class")("CheckBox", require("lml.BaseElement"))
local stub = require("lml.stub")
local Color = require("util.gui.color")
local Style = require("lml.Style")

function CheckBox:__init(data)
    self.checked = data.checked or false ; data.checked = nil
    self.defaultChecked = self.checked ; data.defaultChecked = nil
    self.text = data.text or "" ; data.text = nil
    if not data.checked_color then
        data.checked_color = "#2196F3"
    end
    if not data.unchecked_color then
        data.unchecked_color = "#f2f2f2"
    end
    if not data.hover_color then
        data.hover_color = "#c2c2c2"
    end
    self:__super(data)
    self.type = "CheckBox"
end

function CheckBox:Draw(data)
    local tx, ty = stub.TextSize(self.text, self.style.font_size)
    self.style:DrawText(data.x + self.content.x, data.y + self.content.y, self.text)
    if self.checked then
        stub.DrawRectangle(data.x + self.content.x + tx + ty, data.y + self.content.y, ty, ty, Color(self.style.checked_color))
    elseif self.hover then
        stub.DrawRectangle(data.x + self.content.x + tx + ty, data.y + self.content.y, ty, ty, Color(self.style.hover_color))
    else
        stub.DrawRectangle(data.x + self.content.x + tx + ty, data.y + self.content.y, ty, ty, Color(self.style.unchecked_color))
    end
    self.__super.Draw(self, data)
end

function CheckBox:WndProc(data, mouse, msg, wparam, lparam)
    if self.__super.WndProc(self, data, mouse, msg, wparam, lparam) then
        self.checked = not self.checked
        return true
    end
end

function CheckBox:CalcSize()
    local tx, ty = stub.TextSize(self.text, self.style.font_size)
    self.client.width = tx
    self.client.height = ty
    self.client.width += self.client.height * 2
    self.style:FinalizeSize(self)
end

return CheckBox