local Style = require("util.common.class")("Style")
local Color = require("util.gui.color")
local stub = require("lml.stub")

require("util.extension.all")

function Style:__init(data, el)
    self.color = "#FFF"
    self.line_height = "normal"
    self.font_size = 16
    self.font = nil -- default font
    for k, v in pairs(data) do
        self[k] = v
    end
    if self.opacity then
        self.opacity = Color(1, 1, 1, self.opacity)
    end
    if not self.padding then
        self.padding = { left = 0, right = 0, top = 0, bottom = 0 }
    elseif type(self.padding) == "table" then
        self.padding = { left = self.padding[1] or 0, right = self.padding[2] or 0, top = self.padding[3] or 0, bottom = self.padding[4] or 0 }
    else
        self.padding = { left = self.padding, right = self.padding, top = self.padding, bottom = self.padding }
    end
    if not self.margin then
        self.margin = { left = 0, right = 0, top = 0, bottom = 0 }
    elseif type(self.margin) == "table" then
        self.margin = { left = self.margin[1] or 0, right = self.margin[2] or 0, top = self.margin[3] or 0, bottom = self.margin[4] or 0 }
    else
        self.margin = { left = self.margin, right = self.margin, top = self.margin, bottom = self.margin }
    end
    if not self.border then
        self.border = { width = 0, color = "#000000" }
    elseif type(self.border) == "table" then
        self.border = { width = self.border[1] or 0, color = self.border[2] or "#000000" }
    else
        self.border = { width = self.border, color = "#000000" }
    end
end

function Style:DebugDraw(el)
    local gui = import("gui")
    local bounds = self:GetBoundingRect(el.client)
    local margin = self:GetBoundingRect(el.client)
    local content = self:GetContentRect(el.client)
    local border = self:GetBorderRect(el.client)
	gui.no_stroke()
	gui.fill(Color("#FFF"))
    gui.rectangle(bounds.x, bounds.y, bounds.width, bounds.height)
	gui.fill(Color("#00FF00"))
    gui.rectangle(margin.x, margin.y, self.margin.left, margin.height)
    gui.rectangle(margin.x + margin.width - self.margin.right, margin.y, self.margin.right, margin.height)
    gui.rectangle(margin.x, margin.y, margin.width, self.margin.top)
    gui.rectangle(margin.x, margin.y + margin.height - self.margin.bottom, margin.width, self.margin.bottom)
    gui.fill(Color("#FF0000"))
    gui.rectangle(content.x - self.padding.left, content.y - self.padding.top, self.padding.left, content.height + self.padding.top + self.padding.bottom)
    gui.rectangle(content.x + content.width, content.y - self.padding.top, self.padding.right, content.height + self.padding.top + self.padding.bottom)
    gui.rectangle(content.x - self.padding.left, content.y - self.padding.top, content.width + self.padding.left + self.padding.right, self.padding.top)
    gui.rectangle(content.x - self.padding.left, content.y + content.height, content.width + self.padding.left + self.padding.right, self.padding.bottom)
    gui.fill(Color("#0000FF"))
    gui.rectangle(content.x, content.y, content.width, content.height)
	gui.no_fill()
    gui.stroke(Color(self.border.color))
    gui.stroke_weight(math.max(self.border.width, 1))
    gui.rectangle(border.x, border.y, border.width, border.height)
end

function Style:PreDraw(data, client)
    if self.border.width > 0 then
        local gui = import("gui")
        local border = self:GetBorderRect(client)
        gui.no_fill()
        gui.stroke(Color(self.border.color))
        gui.stroke_weight(math.abs(self.border.width))
        gui.rectangle(data.x + border.x, data.y + border.y, border.width, border.height)
    end
    if self.background_color then
        local content = self:GetBorderRect(client)
        stub.DrawClippedRectangle(data.x + content.x, data.y + content.y, content.width, content.height, Color(self.background_color), data.client)
    end
end

function Style:PostDraw(data)
end

function Style:DrawText(x, y, content)
    if content == "" then
        return
    end
    stub.DrawText(content, self.font_size, x, y, Color(self.color or "#000000"), self.font)
end

function Style:CalcSize(client)
    client.width = client.width + self.margin.left + self.margin.right + self.border.width * 2 + self.padding.left + self.padding.right
    client.height = client.height + self.margin.top + self.margin.bottom + self.border.width * 2 + self.padding.top + self.padding.bottom
end

function Style:FinalizeSize(element)
    self:CalcSize(element.client)
    element.content = self:GetContentRect(element.client)
    element.hitbox = self:GetBorderRect(element.client)
end

function Style:GetBoundingRect(client)
    return { x = client.x, y = client.y, width = client.width, height = client.height }
end

function Style:GetMarginRect(client)
    return { x = client.x + self.margin.left, y = client.y + self.margin.top, width = client.width - self.margin.left - self.margin.right, height = client.height - self.margin.top - self.margin.bottom }
end

function Style:GetBorderRect(client)
    return { x = client.x + self.margin.left + self.border.width, y = client.y + self.margin.top + self.border.width, width = client.width - self.margin.left - self.margin.right - self.border.width * 2, height = client.height - self.margin.top - self.margin.bottom - self.border.width * 2 }
end

function Style:GetContentRect(client)
    return { x = client.x + self.margin.left + self.border.width + self.padding.left, y = client.y + self.margin.top + self.border.width + self.padding.top, width = client.width - self.margin.left - self.margin.right - self.border.width * 2 - self.padding.left - self.padding.right, height = client.height - self.margin.top - self.margin.bottom - self.border.width * 2 - self.padding.top - self.padding.bottom }
end

return Style