---@class Document : BaseElement
local Document = require("util.common.Class")("Document", require("lml.BaseElement"))
local stub = require("lml.stub")
local Style = require("lml.Style")

function Document:__init(data)
    self:__super(data)
    self.width = data.width or "auto" ; data.width = nil ; self:fmt("width")
    self.height = data.height or "auto" ; data.height = nil ; self:fmt("height")
    self.x = data.x or 0 ; data.x = nil ; self:fmt("x")
    self.y = data.y or 0 ; data.y = nil ; self:fmt("y")
    self.type = "Document"
    if self.events.load then
        self.events:load(self)
    end
    self.client = { x = self.x, y = self.y, width = self.width, height = self.height }
    self.row_height = 16
end

function Document:Update(...)
    self.client.width = stub.Width * ~self.width
    self.client.height = stub.Height * ~self.height
    for _, v in ipairs(self.children) do
        v:Update(...)
    end
    for _, v in ipairs(self.children) do
        v:CalcSize()
    end
end

function Document:Draw()
    local data = {
        client = self.client,
        x = self.client.x,
        y = self.client.y,
        width = self.client.width,
        height = 0,
        document = self
    }
    self.style:PreDraw({client = self.client, x=0, y=0}, self.client)
    for _, v in ipairs(self.children) do
        v:PreDraw(data)
        v:Draw(data)
        v:PostDraw(data)
    end
    self.style:PostDraw({x=0,y=0}, self.client)
end

function Document:WndProc(mouse, msg, wparam, lparam)
    local data = {
        client = self.client,
        x = self.client.x,
        y = self.client.y,
        width = self.client.width,
        height = 0,
        document = self
    }
    for _, v in ipairs(self.children) do
        v:WndProc(data, mouse, msg, wparam, lparam)
    end
end

return Document