---@class BaseElement
local BaseElement = require("util.common.Class")("BaseElement")
local stub = require("lml.stub")
local Style = require("lml.Style")

function BaseElement:__init(data)
    self.children = {}
    self.data = {}
    self.events = {}
    self.style = {}
    self.type = "BaseElement"
    self.client = { x = 0, y = 0, width = 0, height = 0 }
    self.content = { x = 0, y = 0, width = 0, height = 0 }
    self.contenteditable = data.contenteditable or false    ; data.contenteditable = nil
    self.dir = data.dir or "ltr"                            ; data.dir = nil
    self.draggable = data.draggable or false                ; data.draggable = nil
    self.hidden = data.hidden or false                      ; data.hidden = nil
    self.id = data.id or ""                                 ; data.id = nil
    self.inert = data.inert or false                        ; data.inert = nil
    self.title = data.title or ""                           ; data.title = nil
    if type(data) == "string" then
        self(data)
    else
        for k, v in pairs(data) do
            if type(k) == "number" then continue end
            if k:sub(1, 2) == "on" then
                self.events[k:sub(3)] = v
            elseif k:find("^data-") then
                self.data[k:sub(6)] = v
            else
                self.style[k] = v
            end
        end
        for i = 1, #data do
            data[i].parent = self
            table.insert(self.children, data[i])
        end
    end
    self.style = Style(self.style, self)
end

function BaseElement:Update(...)
end

function BaseElement:PreDraw(data)
    self.style:PreDraw(data, self.client)
    data.x += self.client.width
    data.height = math.max(data.height, self.client.height)
end

function BaseElement:Draw(data)
    data.x += self.client.width
    data.height = math.max(data.height, self.client.height)
end

function BaseElement:PostDraw(data)
    self.style:PostDraw(data, self.client)
end

function BaseElement:WndProc(data, mouse, msg, wparam, lparam)
    if not self.hitbox then return false end
    for _, v in ipairs(self.children) do
        if v:WndProc(data, mouse, msg, wparam, lparam) then
            return true
        end
    end
    if mouse.x < data.x + self.hitbox.x or mouse.x > data.x + self.hitbox.x + self.hitbox.width or mouse.y < data.y + self.hitbox.y or mouse.y > self.hitbox.y + data.y + self.hitbox.height then
        data.x += self.client.width
        data.height = math.max(data.height, self.client.height)
        self.hover = false
        return false
    end
    self.hover = true
    data.x += self.client.width
    data.height = math.max(data.height, self.client.height)
    if msg == ENUMS.WM.LButtonDown then
        if self.events.click then
            self.events:click()
        end
        stub.clicked(self)
        return true
    end
end

function BaseElement:CalcSize()
    if type(self.width) == "string" then
        if self.parent then
            self.client.width = self.parent.client.width * ~self.width
        end
    else
        self.client.width = self.width
    end
    if self.height == "auto" then
        self.client.height = self.client.width * ih / iw
    elseif type(self.height) == "string" then
        if self.parent then
            self.client.height = self.parent.client.width * ~self.height
        end
    else
        self.client.height = self.height
    end
    self.style:FinalizeSize(self)
end

function BaseElement:fmt(idx)
    if type(self[idx]) == "string" then
        if self[idx] == "auto" then
            return
        end
        if self[idx]:sub(-2) == "px" then
            self[idx] = tonumber(self[idx]:sub(1, -3))
        elseif self[idx]:find("^%d+$") then
            self[idx] = tonumber(self[idx])
        end
    end
end

return BaseElement