local gui = require("gui")
local events = import("events", "local")

gui.camera.type = "perspective"
gui.camera.fov = 30
gui.camera.height = 20
gui.camera.angle = 1

local function UpdateCameraPosition(v)
    if v then
        gui.camera.target = v
    else
        v = gui.camera.target
    end
    local x = v.x - gui.camera.height * 1.00 * gui.camera.angle
    local y = v.y + gui.camera.height * 1.46 * gui.camera.angle * gui.camera.angle
    local z = v.z - gui.camera.height * 1.00 * gui.camera.angle
    gui.camera.position = {x, y, z}
end

UpdateCameraPosition({ x = 0, y = 0, z = 0})

events.update += function(dt)
    if gui.mouse.ScrollWheel ~= 0 then
        gui.camera.angle = gui.camera.angle - gui.mouse.ScrollWheel / 2400
        if gui.camera.angle < 0.25 then gui.camera.angle = 0.25 end
        if gui.camera.angle > 1.00 then gui.camera.angle = 1.00 end
        gui.mouse:ResetScrollWheelValue()
        UpdateCameraPosition()
    end
end

return {
    update = UpdateCameraPosition
}