return function(width, height, wtype)
    if type(width) == "string" then
        wtype, width, height = width, height, wtype
    end
    local settings = require("util.common.settings")()
    local events = require("util.common.events")
    local gui = import("gui")
    if wtype :find "pos" and settings.get("window") then
        local window = settings.get("window")
        gui.size(window.x, window.y, window.width, window.height)
        if math.abs(window.x - 0) < 50
            and math.abs(window.y - 0) < 50
            and math.abs(window.width - primary_monitor.w) < 50
            and math.abs(window.height - primary_monitor.h) < 50 then
            gui.style |= gui.styles.MAXIMIZE
        end
        events.shutdown += function()
            settings.set("window", { x = gui.x, y = gui.y, width = gui.width, height = gui.height })
        end
        return
    end
    if wtype :find "center" then
        local primary_monitor = require("util.gui.monitors").primary
        width = width or primary_monitor.w * 0.5
        height = height or primary_monitor.h * 0.5
        local window = settings.get("window", {x = primary_monitor.x + primary_monitor.w * 0.5 - width * 0.5, y = primary_monitor.y + primary_monitor.h * 0.5 - height * 0.5, width = width, height = height})
        gui.size(window.x, window.y, width, height)
    elseif wtype :find "fulls" then
        gui.fullscreen = true
    elseif wtype :find "max" then
        local primary_monitor = require("util.gui.monitors").primary
        gui.size(primary_monitor.w, primary_monitor.h)
        gui.style |= gui.styles.MAXIMIZE
    else
        gui.size(width, height)
    end
    if wtype :find "pos" then
        events.shutdown += function()
            settings.set("window", { x = gui.x, y = gui.y, width = gui.width, height = gui.height })
        end
    end
end