---@class File : Class
---@field f file*
---@field size number
---@field content string
---@field name string
local File = require("util.common.class")()

function File:__init(name)
    local f = io.open(name, "rb")
    if not f then
        error(("Couldn't open file: %s"):format(name))
    end
    self.f = f
    self.size = self.f:seek("end")
    self.f:seek("set", 0)
    self.content = self.f:read("*a")
    self.f:seek("set", 0)
    self.name = name
end

function File:__gc()
    if not self.closed then
        self.f:close()
        self.closed = true
    end
end

function File:close()
    if not self.closed then
        self.f:close()
        self.closed = true
    end
end

function File:sub(offset, size)
    self.f:seek("set", offset + 1)
    return self.f:read(size or "*a")
end

function File:read(size)
    return self.f:read(size or "*a")
end

function File:seek(offset, whence)
    return self.f:seek(whence or "set", offset or 0)
end

function File:pos()
    return self.f:seek()
end

return File