local Box = import("box", "local")

---@class Events
---@field click Box<number, fun(pos : Vector)>
---@field key_down Box<number, fun(key : number)>
---@field key_up Box<number, fun(key : number)>
---@field wnd_proc Box<number, fun(hwnd : number, msg : number, wParam : number, lParam : number)>
---@field resize Box<number, fun(hwnd : number, x : number, y : number, w : number, h : number)>
---@field initialize Box<number, fun()>
---@field update Box<number, fun(dT : number)>
---@field render Box<number, fun(layer : number)>
---@field activated Box<number, fun()>
---@field deactivated Box<number, fun()>
---@field suspending Box<number, fun()>
---@field resuming Box<number, fun()>
---@field display_change Box<number, fun()>
---@field window_size_changed Box<number, fun(w : number, h : number)>
---@field window_moved Box<number, fun(x : number, y : number)>
---@field screen_mode_changed Box<number, fun(fullscreen : boolean)>
---@field device_lost Box<number, fun()>
---@field device_restored Box<number, fun()>
---@field shutdown Box<number, fun()>
---@field html Box<number, fun(event : string, data : any)>
---@field delay fun(cb : fun(...), t : number, ... : any)
local Events = {
    click = Box({}, "events.click"),
    key_down = Box({}, "events.key_down"),
    key_up = Box({}, "events.key_up"),
    wnd_proc = Box({}, "events.wnd_proc"),
    resize = Box({}, "events.resize"),
    initialize = Box({}, "events.initialize"),
    update = Box({}, "events.update"),
    render = Box({}, "events.render"),
    activated = Box({}, "events.activated"),
    deactivated = Box({}, "events.deactivated"),
    suspending = Box({}, "events.suspending"),
    resuming = Box({}, "events.resuming"),
    display_change = Box({}, "events.display_change"),
    window_size_changed = Box({}, "events.window_size_changed"),
    window_moved = Box({}, "events.window_moved"),
    screen_mode_changed = Box({}, "events.screen_mode_changed"),
    device_lost = Box({}, "events.device_lost"),
    device_restored = Box({}, "events.device_restored"),
    shutdown = Box({}, "events.shutdown"),
    html = Box({}, "events.html"),

    list = {
        "click",
        "key_down",
        "key_up",
        "wnd_proc",
        "resize",
        "initialize",
        "update",
        "render",
        "activated",
        "deactivated",
        "suspending",
        "resuming",
        "display_change",
        "window_size_changed",
        "window_moved",
        "screen_mode_changed",
        "device_lost",
        "device_restored",
        "shutdown",
        "html",
    }
}

Events.new = function(e)
    Events[e] = Events[e] or Box{}
end

---@param cb function
---@param t number
---@vararg any
Events.delay = function(cb, t, ...)
    local args = {...}
    t += clock()
    local function f()
        if t <= clock() then
            Events.update -= f
            cb(table.unpack(args))
        end
    end
    Events.update += f
end

return Events