local Enums = {}

Enums.BoxCallType =
{
    And = 1,
    Or = 2
}

---@class Enum
---@generic T
---@param t T
---@return T
local function Enum(t)
    for i, v in pairs(t) do
        t[v] = i
    end
    return t
end
Enums.Enum = Enum

Enums.VK = Enum
{
    "MMButton",
    "XMButton1",
    "XMButton2",
    "XMButton3",
    "XMButton4",
    "XMButton5",
    "Undefined",
    "Backspace",
    "Tab",
    "Reserved6",
    "Reserved7",
    "Clear",
    "Enter",
    "Undefined",
    "Undefined",
    "Shift",
    "Ctrl",
    "Alt Gr",
    "Pause",
    "Caps Lock",
    "Reserved",
    "Undefined",
    "Reserved",
    "Reserved",
    "Reserved",
    "Undefined",
    "Esc",
    "Convert",
    "Non Convert",
    "Accept",
    "Reserved",
    "Space",
    "Page Up",
    "Page Down",
    "End",
    "Home",
    "Left Arrow",
    "Up Arrow",
    "Right Arrow",
    "Down Arrow",
    "Select",
    "Print",
    "Execute",
    "Print Screen",
    "Insert",
    "Delete",
    "Help",
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
    "Undefined",
    "Undefined",
    "Undefined",
    "Undefined",
    "Undefined",
    "Undefined",
    "Undefined",
    "A",
    "B",
    "C",
    "D",
    "E",
    "F",
    "G",
    "H",
    "I",
    "J",
    "K",
    "L",
    "M",
    "N",
    "O",
    "P",
    "Q",
    "R",
    "S",
    "T",
    "U",
    "V",
    "W",
    "X",
    "Y",
    "Z",
    "Windows",
    "Windows",
    "Reserved",
    "Reserved",
    "Sleep",
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
    "*",
    "+",
    "_",
    "-",
    ".",
    "/",
    "F1",
    "F2",
    "F3",
    "F4",
    "F5",
    "F6",
    "F7",
    "F8",
    "F9",
    "F10",
    "F11",
    "F12",
    "F13",
    "F14",
    "F15",
    "F16",
    "F17",
    "F18",
    "F19",
    "F20",
    "F21",
    "F22",
    "F23",
    "F24",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Num Lock",
    "Scroll Lock",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Left Shift",
    "Right Shift",
    "Left Control",
    "Right Control",
    "Left Menu",
    "Right Menu",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    ";",
    "+",
    ",",
    "-",
    ".",
    "/",
    "#",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "[",
    "\\",
    "]",
    "'",
    "`",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved",
    "Reserved"
}

Enums.WM = Enum
{
    Null = 0,
    Create = 1,
    Destroy = 2,
    Move = 3,
    Size = 5,
    Activate = 6,
    SetFocus = 7,
    KillFocus = 8,
    Enable = 10,
    SetRedraw = 11,
    SetText = 12,
    GetText = 13,
    GetTextLength = 14,
    Paint = 15,
    Close = 16,
    QueryEndSession = 17,
    QueryOpen = 19,
    EndSession = 22,
    Quit = 23,
    EraseBkgnd = 20,
    SetCursor = 24,
    MouseMove = 512,
    LButtonDown = 513,
    LButtonUp = 514,
    LButtonDblClk = 515,
    RButtonDown = 516,
    RButtonUp = 517,
    RButtonDblClk = 518,
    MButtonDown = 519,
    MButtonUp = 520,
    MButtonDblClk = 521,
    MouseWheel = 522,
    MouseHWheel = 523,
    KeyDown = 256,
    KeyUp = 257,
    SysKeyDown = 260,
    SysKeyUp = 261,
    Char = 258,
    DeadChar = 259,
    SysChar = 262,
    SysDeadChar = 263,
    ContextMenu = 577,
    Command = 273,
    Timer = 275,
    InitMenu = 278,
    InitDialog = 272,
    Sizing = 532,
    Moving = 534,
    CaptureChanged = 533,
    DeviceChange = 537,
    DeviceModeChange = 538,
    InputLangChange = 539,
    Input = 772,
    UniChar = 770
}

return Enums