local class_storage = require("ecs.entity_storage")
local component_storage = require("ecs.component_storage")
local function apply(tt, d, override)
    for k, v in pairs(d) do
        if type(v) == "table" then
            if not tt[k] then
                tt[k] = { }
            end
            apply(tt[k], v, override)
        elseif override or not tt[k] then
            tt[k] = v
        end
    end
    return tt
end
local function capply(new, old, d)
    for k, v in pairs(d) do
        if not old[k] then
            continue
        end
        if type(v) == "table" then
            if not new[k] then
                new[k] = { }
            end
            capply(new[k], old[k], v)
        else
            new[k] = old[k]
        end
    end
    return new
end
local function make_component_table(t)
    return setmetatable(t, {
        __add = function(a, b)
            if type(a) == "table" then
                a[#a + 1] = b
                return a
            else
                error("Attempt to add non-tables")
            end
        end,
        __sub = function(a, b)
            if type(a) == "table" then
                for i, v in ipairs(a) do
                    if v == b then
                        table.remove(a, i)
                        return a
                    end
                end
                return a
            else
                error("Attempt to subtract non-tables")
            end
        end
    })
end
return function(name)
    if class_storage[name] then
        return class_storage[name].helper
    end
    local cls = setmetatable({}, {
        __tostring = function(self)
            return "entity{" .. name .. "}"
        end
    })
    cls.__name = name
    cls.__defaults = {}
    cls.__components = make_component_table({})
    cls.__parents = {}
    cls.add_component = function(self, component)
        local t, classes, components = {}, {}, {}
        apply(t, cls.__defaults, true)
        cls.__apply_defaults(t, classes, components)
        local new_t = cls.build(t, component_storage[component].class.__defaults)()
        new_t = capply(new_t, self, t)
        apply(new_t, component_storage[component].class.__defaults, true)
        new_t.__id = self.__id
        self = new_t
        return self
    end
    cls.remove_component = function(self, component)
        --for k, v in pairs(component_storage[component].class.__defaults) do
        --    self[k] = nil
        --end
    end
    cls.__tostring = function(self)
        local temp = getmetatable(self)
        setmetatable(self, nil)
        local ret = name .. "{" .. tostring(self):match("(0x%x+)") .. "}"
        setmetatable(self, temp)
        return ret
    end
    cls.__call = function(self, ...)
        if self.__init then
            local r = self.__init(self, ...)
            return r or self
        end
        return self
    end
    cls.__apply_defaults = function(t, classes, components)
        for i, p in ipairs(cls.__parents) do
            if class_storage[p] and type(class_storage[p]) == "table" and class_storage[p].class then
                class_storage[p].class.__apply_defaults(t, classes, components)
            end
        end
        for k, v in pairs(cls.__components) do
            apply(t, component_storage[v].class.__defaults)
            components[v] = true
        end
        apply(t, cls.__defaults, true)
        classes[#classes + 1] = cls.__name
    end
    local ffi = require("ffi")
    cls.build = function(t, extra)
        local str = "struct { "
        str = str .. " unsigned long int __id; "
        local function build(t, str)
            for k, v in pairs(t) do
                if type(v) == "table" then
                    str = str .. "struct { "
                    str = build(v, str)
                    str = str .. " } " .. k .. "; "
                elseif type(v) == "number" then
                    str = str .. "double " .. k .. "; "
                else
                    str = str .. ffi.typeof(v) .. " " .. k .. "; "
                end
            end
            return str
        end
        str = build(t, str)
        if extra then
            str = build(extra, str)
        end
        str = str .. " }"
        return ffi.typeof(str)
    end
    cls.new = function()
        local t, classes, components = {}, {}, {}
        cls.__apply_defaults(t, classes, components)
        if not cls.ctype then
            cls.ctype = cls.build(t)
        end
        t = apply(cls.ctype(), t, true)
        return t, classes, components
    end
    local helper = setmetatable({ }, {
        __call = function(_, init, extra)
            for k, v in pairs(extra or init) do
                if k == name then
                    cls.__init = v
                else
                    cls.__defaults[k] = v
                end
            end
            getmetatable(_).__call = function(_, ...)
                local new = cls.new()
                if new.__init then
                    new:__init(...)
                end
                return new
            end
            return _
        end,
        __index = function(_, k)
            if k == "defaults" then
                return cls.__defaults
            end
            if k == "components" then
                return cls.__components
            end
            if k == "parents" then
                return cls.__parents
            end
            if k == "extends" then
                return function(...)
                    for i, p in ipairs({...}) do
                        cls.__parents[#cls.__parents + 1] = p
                    end
                    return _
                end
            end
            if k == "new" then
                return cls.new
            end
            cls.__parents[#cls.__parents + 1] = k
            return rawget(cls, k) or _
        end,
        __newindex = function(_, k, v)
            if k == "components" then
                cls.__components = make_component_table(v)
            end
            rawset(cls, k, v)
        end
    })
    class_storage[name] = {
        class = cls,
        helper = helper
    }
    return helper
end