local component_storage = require("ecs.component_storage")
return function(name)
    local cls = setmetatable({}, {
        __tostring = function(self)
            return "component{" .. name .. "}"
        end
    })
    cls.__index = cls
    cls.__name = name
    cls.__defaults = {}

    local helper = setmetatable({ }, {
        __call = function(_, init, extra)
            for k, v in pairs(extra or init) do
                if k == name then
                    cls.__init = v
                else
                    cls.__defaults[k] = v
                end
            end
            return _
        end,
        __index = function(_, k)
            if k == "defaults" then
                return cls.__defaults
            end
            return rawget(cls, k) or _
        end,
        __newindex = function(_, k, v)
            rawset(cls, k, v)
        end
    })
    component_storage[name] = {
        class = cls,
        helper = helper
    }
    return helper
end