local function make_component_table(t)
    return setmetatable(t, {
        __add = function(a, b)
            if type(a) == "table" then
                a[#a + 1] = b
                return a
            else
                error("Attempt to add non-tables")
            end
        end,
        __sub = function(a, b)
            if type(a) == "table" then
                for i, v in ipairs(a) do
                    if v == b then
                        table.remove(a, i)
                        return a
                    end
                end
                return a
            else
                error("Attempt to subtract non-tables")
            end
        end
    })
end
local class_storage = require("ecs.storage")
return function(name)
    if class_storage[name] then
        return class_storage[name].helper
    end
    local cls = setmetatable({}, {
        __tostring = function(self)
            return "class{" .. name .. "}"
        end
    })
    cls.__index = cls
    cls.__name = name
    cls.__defaults = {}
    cls.__components = make_component_table({})
    cls.__parents = {}
    cls.__tostring = function(self)
        local temp = getmetatable(self)
        setmetatable(self, nil)
        local ret = name .. "{" .. tostring(self):match("(0x%x+)") .. "}"
        setmetatable(self, temp)
        return ret
    end
    cls.__call = function(self, ...)
        if self.__init then
            local r = self.__init(self, ...)
            return r or self
        else
            error("No constructor found for class " .. name)
        end
    end
    cls.__apply_defaults = function(t)
        for i, p in ipairs(cls.__parents) do
            if class_storage[p] and type(class_storage[p]) == "table" and class_storage[p].class then
                local parent = class_storage[p].class
                if not t.__super then
                    t.__super = parent
                else
                    t.__supers = t.__supers or {}
                    t.__supers[#t.__supers + 1] = parent
                end
                parent.__apply_defaults(t)
            end
        end
        for k, v in pairs(cls.__defaults) do
            t[k] = v
        end
        for k, v in pairs(cls.__components) do
            t.__components[k] = v
        end
        return t
    end
    cls.new = function()
        return cls.__apply_defaults(setmetatable({
            __components = make_component_table({}),
            __class = cls
        }, cls))
    end
    local helper = setmetatable({ }, {
        __call = function(_, init, extra)
            for k, v in pairs(extra or init) do
                if k == name then
                    cls.__init = v
                else
                    cls.__defaults[k] = v
                end
            end
            return _
        end,
        __index = function(_, k)
            if k == "defaults" then
                return cls.__defaults
            end
            if k == "components" then
                return cls.__components
            end
            if k == "parents" then
                return cls.__parents
            end
            if k == "extends" then
                return function(...)
                    for i, p in ipairs({...}) do
                        cls.__parents[#cls.__parents + 1] = p
                    end
                    return _
                end
            end
            if k == "new" then
                return cls.new
            end
            cls.__parents[#cls.__parents + 1] = k
            return rawget(cls, k) or _
        end,
        __newindex = function(_, k, v)
            if k == "components" then
                cls.__components = make_component_table(v)
            end
            rawset(cls, k, v)
        end
    })
    class_storage[name] = {
        class = cls,
        helper = helper
    }
    return helper
end