---@class Class
---@field __properties table<string, table<string, fun(self:Class):any>>
---@field __metatable table
---@field __super Class
---@field __class Class
---@field __name string
---@field __instance Class
---@return Class
return function(name, super)
  assert(not name or type(name) == "string", debug.traceback("Class name must be a string", 2))
  assert(not super or type(super) == "table" and super.__class, debug.traceback("Super class must be a class", 2))
  local class, metatable, properties = {}, { __name = name, __super = super }, {}
  class.__class = class
  class.__metatable = metatable
  class.__properties = properties
  setmetatable(properties, {
    __index = function(self, n)
      local result = rawget(self, n)
      if result then
        return result
      else
        rawset(self, n, {})
        return rawget(self, n)
      end
    end
  })
  local in_init
  local function in_init_contains(init)
    for i = 1, #in_init do
      if in_init[i] == init then
        return true
      end
    end
    return false
  end
  local function lookup_super()
    if not super then
      return nil
    end
    if in_init then
      local s = super
      while s and in_init_contains(s) do
        s = s.__metatable.__super
      end
      if s then
        return function(...)
          in_init[#in_init + 1] = s
          s.__init(...)
          select(1, ...).__super = s
        end
      end
    end
    return super
  end
  if super then
    function metatable:__index(key)
      local result = rawget(self, key)
      if result then
        return result
      end
      result = rawget(class, key)
      if result then
        return result
      end
      if super then
        result = rawget(super, key)
        if result then
          return result
        end
      end
      local prop = properties[key]
      if prop and prop.get then
        return prop.get(self)
      end
      result = rawget(self, "__metatable")
      if result then
        result = result[key]
        if result then
          return result
        end
      end
      result = rawget(class, "__metatable")
      if result then
        result = result[key]
        if result then
          if key == "__super" and in_init then
            return lookup_super()
          end
          return result
        end
      end
      if super then
        local meta = rawget(super, "__metatable")
        if meta then
          result = meta[key]
          if result then
            return result
          end
        end
        return meta.__index(self, key)
      end
    end
  else
    function metatable:__index(key)
      local result = rawget(self, key)
      if result then
        return result
      end
      result = rawget(class, key)
      if result then
        return result
      end
      local prop = properties[key]
      if prop and prop.get then
        return prop.get(self)
      end
      result = rawget(self, "__metatable")
      if result then
        result = result[key]
        if result then
          return result
        end
      end
      result = rawget(class, "__metatable")
      if result then
        result = result[key]
        if result then
          return result
        end
      end
    end
  end
  local mt_lookup = {
    __gc = true,
    __call = true,
    __tostring = true,
    __unm = true,
    __add = true,
    __sub = true,
    __mul = true,
    __div = true,
    __mod = true,
    __pow = true,
    __concat = true,
    __eq = true,
    __lt = true,
    __le = true,
    __len = true,
  }
  function metatable:__newindex(key, value)
    if mt_lookup[key] then
      if key == "__gc" and newproxy and not self.__metatable.__proxy then
        self.__metatable.__proxy = newproxy(true) -- fuck luajit wtf
        getmetatable(self.__metatable.__proxy).__gc = function()
          self.__metatable.__gc(self)
        end
      end
      return rawset(self.__metatable, key, value)
    end
    local prop = properties[key]
    if prop and prop.set then
      return prop.set(self, value)
    else
      return rawset(self, key, value)
    end
  end
  if newproxy then
    function metatable:__call(...)
      local obj = {}
      if self.__metatable.__gc or super and super.__metatable.__gc then
        local mt = {}
        for i, v in pairs(self.__metatable) do
          mt[i] = v
        end
        obj.__proxy = newproxy(true)
        getmetatable(obj.__proxy).__gc = function()
          if super and super.__metatable.__gc then
            super.__metatable.__gc(obj)
          end
          if self.__metatable.__gc then
            self.__metatable.__gc(obj)
          end
        end
        obj = setmetatable(obj, mt)
      else
        obj = setmetatable(obj, self.__metatable)
      end
      if class.__init then
        in_init = {class.__init}
        class.__instance = obj
        local s, e = pcall(class.__init, obj, ...)
        if not s then
          printf("!> Error in %s.__init: %s", tostring(name), debug.traceback(e))
        end
        in_init = nil
      end
      return obj
    end
  else
    function metatable:__call(...)
      local obj = setmetatable({ }, self.__metatable)
      if class.__init then
        in_init = {class.__init}
        class.__instance = obj
        local s, e = pcall(class.__init, obj, ...)
        if not s then
          printf("!> Error in %s.__init: %s", tostring(name), debug.traceback(e))
        end
        in_init = nil
      end
      return obj
    end
  end
  local mt_copy = {}
  for i, v in pairs(class.__metatable) do
    mt_copy[i] = v
  end
  setmetatable(class, mt_copy)
  return class
end