local resolve__pcall = function(t, ...)
    if type(t) == "function" then
        return pcall(t, ...)
    end
    local mt = getmetatable(t)
    if mt and mt.__call then
        return pcall(mt.__call, t, ...)
    end
    return pcall(t[1], t[2], ...)
end
local resolve__call = function(t, ...)
    if type(t) == "function" then
        return t(...)
    end
    local mt = getmetatable(t)
    if mt and mt.__call then
        return mt.__call(t, ...)
    end
    if not t[1] then
        printft(debug.traceback())
    end
    return t[1](t[2], ...)
end

---@return Box
local function Box(inp, t)
    local tbl
    if type(inp) ~= "table" then
        local n = inp()
        tbl = {}
        while (n) do
            tbl[#tbl + 1] = n
            n = inp()
        end
        inp = nil
    else
        tbl = inp
    end
    ---@class Box
    ---@field ref table<number, any>
    ---@field count number
    ---@field type string Box
    local b = setmetatable({ ref = tbl, count = #tbl, type = "Box" },
    {
        __tostring = function(self)
            return "Box{" .. (self.fold(`(x, y) => (y and tostring(y) .. ', ' or '') .. tostring(x)`) or '') .. "}"
        end,
        __add = function(self, other)
            return self.add(other)
        end,
        __sub = function(self, other)
            return self.sub(other)
        end,
        __iter = function(self)
            local __idx__ = 0
            return function()
                if __idx__ < self.count then
                    __idx__ += 1
                    return self.ref[__idx__]
                end
            end
        end,
        __call = function(self, ...)
            return self.call(...)
        end,
        __index = function(self, n)
            local res = rawget(self, n)
            if rawget(self, n) then
                return res
            end
            return rawget(self, "ref")[n]
        end,
        __eq = function(self, n)
            return type(n) == "table" and n.ref == self.ref
        end
    })
    b.id = t
    b.skip = function(where, amount)
        if type(where) == "number" then where, amount = "begin", where end
        local newref = {}
        for i = 1 + (where == "begin" and amount or 0), b.count - (where == "end" and amount or 0) do
            newref[#newref + 1] = b.ref[i]
        end
        return Box(newref, b.id)
    end
    b.invoke = function(...)
        for i = 1, b.count do
            resolve__call(b.ref[i], ...)
        end
    end
    b.pinvoke = function(...)
        for i = 1, b.count do
            local status, err = resolve__pcall(b.ref[i], ...)
            if not status then
                printft(err .. "\n" .. debug.functrace(b.ref[i]))
            end
        end
    end
    b.empty = function()
        return b.count == 0
    end
    b.size = function()
        return b.count
    end
    b.at = function(idx)
        return b.ref[idx]
    end
    b.iter = function(idx)
        local i = 0
        return function()
            i += 1
            return b.ref[i]
        end, b.ref, nil
    end
    if _G.DEBUGGER_ACTIVE then
        b.call = function(...)
            if b.id == 1 then
                for i = 1, b.count do
                    debug.current_invoke = b.id
                    local s, r = resolve__pcall(b.ref[i], ...)
                    debug.current_invoke = nil
                    if s and not r then
                        return false
                    end
                end
                return true
            elseif b.id == 2 then
                for i = 1, b.count do
                    debug.current_invoke = b.id
                    local s, r = resolve__pcall(b.ref[i], ...)
                    debug.current_invoke = nil
                    if s and r then
                        return true
                    end
                end
                return false
            end
            for i = 1, b.count do
                debug.current_invoke = b.id
                local results = { resolve__pcall(b.ref[i], ...) }
                debug.current_invoke = nil
                if #results > 1 then
                    for j = 1 , #results do
                        results[j] = results[j + 1]
                    end
                    return unpack(results)
                end
            end
        end
    else
        b.call = function(...)
            if b.id == 1 then
                for i = 1, b.count do
                    if not resolve__call(b.ref[i], ...) then
                        return false
                    end
                end
                return true
            elseif b.id == 2 then
                for i = 1, b.count do
                    if resolve__call(b.ref[i], ...) then
                        return true
                    end
                end
                return false
            end
            for i = 1, b.count do
                local results = { resolve__call(b.ref[i], ...) }
                if #results > 0 then
                    return unpack(results)
                end
            end
        end
    end
    b.invoke_until = function(...)
        for i = 1, b.count do
            if resolve__call(b.ref[i], ...) then
                return true
            end
        end
        return false
    end
    b.invoke_unless = function(...)
        for i = 1, b.count do
            if resolve__call(b.ref[i], ...) == false then
                return false
            end
        end
        return true
    end
    b.add = function(o)
        if type(o) == "table" then
            if o.type and o.type%"Box" then
                for e in o.iter() do
                    b.count += 1
                    b.ref[b.count] = e
                end
            elseif #o > 0 then
                for i = 1, #o do
                    b.count += 1
                    b.ref[b.count] = o[i]
                end
            elseif getmetatable(o) == nil then
                for _, element in pairs(o) do
                    b.count += 1
                    b.ref[b.count] = element
                end
            else
                b.count += 1
                b.ref[b.count] = o
            end
        else
            b.count += 1
            b.ref[b.count] = o
        end
        return Box(b.ref, b.id)
    end
    b.sub = function(o)
        if type(o) == "table" then
            if o.type and o.type%"Box" then
                for e in o.iter() do
                    b.sub(e)
                end
                return Box(b.ref, b.id)
            elseif #o > 0 then
                for i = 1, #o do
                    b.sub(o[i])
                end
                return Box(b.ref, b.id)
            elseif getmetatable(o) == nil then
                for _, element in pairs(o) do
                    b.sub(element)
                end
                return Box(b.ref, b.id)
            end
        end
        for i = 1, b.count do
            if b.ref[i] == o then
                b.ref[i] = nil
                for j = i, b.count - 1 do
                    b.ref[j] = b.ref[j + 1]
                end
                b.count -= 1
                break
            end
        end
        return Box(b.ref, b.id)
    end
    b.merge = function(o)
        local newref = { }
        for i = 1, b.count do
            newref[#newref + 1] = b.ref[i]
        end
        if type(o) == "table" then
            if o.type and o.type%"Box" then
                for e in o.iter() do
                    newref[#newref + 1] = e
                end
            elseif #o > 0 then
                for i = 1, #o do
                    newref[#newref + 1] = o[i]
                end
            elseif getmetatable(o) == nil then
                for _, element in pairs(o) do
                    newref[#newref + 1] = element
                end
            else
                newref[#newref + 1] = o
            end
        else
            newref[#newref + 1] = o
        end
        return Box(newref, b.id)
    end
    b.copy = function()
        local newref = {}
        for i = 1, b.count do
            newref[#newref + 1] = b.ref[i]
        end
        return Box(newref, b.id)
    end
    b.remove = function(o)
        local newref = {}
        for i = 1, b.count do
            if b.ref[i] ~= o then
                newref[#newref + 1] = b.ref[i]
            end
        end
        return Box(newref, b.id)
    end
    b.any = function(t, ...)
        local t_type = type(t)
        if t_type == "function" then
            for i = 1, b.count do
                if t(b.ref[i], ...) then
                    return true
                end
            end
        else
            return b.count > 0
        end
        return false
    end
    b.where = function(t, ...)
        local newref = {}
        local t_type = type(t)
        if t_type == "function" then
            for i = 1, b.count do
                if t(b.ref[i], ...) then
                    newref[#newref + 1] = b.ref[i]
                end
            end
        end
        return Box(newref, b.id)
    end
    b.except = function(t, ...)
        local newref = { }
        local t_type = type(t)
        if t_type == "function" then
            for i = 1, b.count do
                if not t(b.ref[i], ...) then
                    newref[#newref + 1] = b.ref[i]
                end
            end
        end
        return Box(newref, b.id)
    end
    b.for_each = function(t, ...)
        local t_type = type(t)
        if t_type == "function" then
            for i = 1, b.count do
                t(b.ref[i], ...)
            end
        end
        return b
    end
    b.rfor_each = function(t, ...)
        local t_type = type(t)
        if t_type == "function" then
            for i = b.count, 1, -1 do
                t(b.ref[i], ...)
            end
        end
        return b
    end
    b.for_each_until = function(t, ...)
        local t_type = type(t)
        if t_type == "function" then
            for i = 1, b.count do
                if t(b.ref[i], ...) then
                    return b
                end
            end
        end
        return b
    end
    b.rfor_each_until = function(t, ...)
        local t_type = type(t)
        if t_type == "function" then
            for i = b.count, 1, -1 do
                if t(b.ref[i], ...) then
                    return b
                end
            end
        end
        return b
    end
    b.first = function(t, ...)
        local t_type = type(t)
        if t_type == "function" then
            for i = 1, b.count do
                if t(b.ref[i], ...) then
                    return b.ref[i]
                end
            end
        else
            return b.ref[1]
        end
        return nil
    end
    b.last = function(t, ...)
        local t_type = type(t)
        if t_type == "function" then
            for i = b.count, 1, -1 do
                if t(b.ref[i], ...) then
                    return b.ref[i]
                end
            end
        else
            return b.ref[b.count]
        end
        return nil
    end
    b.fold = function(t, ...)
        if b.count == 0 then
            return nil
        end
        local t_type = type(t)
        if t_type == "function" then
            local o = t(b.ref[1], ...)
            for i = 2, b.count do
                o = t(b.ref[i], o, ...)
            end
            return o
        end
        return nil
    end
    b.clear = function()
        b.count = 0
        b.ref = {}
        return b
    end
    b.apply = function(t, ...)
        local newref = {}
        local t_type = type(t)
        if t_type == "table" then
            for _, v in pairs(t) do
                for i = 1, b.count do
                    newref[i] = v(b.ref[i], ...)
                end
            end
        elseif t_type == "function" then
            for i = 1, b.count do
                newref[i] = t(b.ref[i], ...)
            end
        end
        return Box(newref, b.id)
    end
    b.order = function(t, ...)
        local t_type = type(t)
        if t_type == "function" then
            local sorted = b.count == 0
            while not sorted do
                sorted = true
                for i = 1, b.count - 1 do
                    if t(b.ref[i], b.ref[i + 1], ...) then
                        b.ref[i], b.ref[i + 1] = b.ref[i + 1], b.ref[i]
                        sorted = false
                    end
                end
            end
        else
            local sorted = b.count == 0
            while not sorted do
                sorted = true
                for i = 1, b.count - 1 do
                    if b.ref[i] > b.ref[i + 1] then
                        b.ref[i], b.ref[i + 1] = b.ref[i + 1], b.ref[i]
                        sorted = false
                    end
                end
            end
        end
        return b
    end
    return b
end
return Box