local thread = import("thread")

return function(f, db1, db2)
    local promise = {
        thread = thread()
    }
    promise.thread:load(f)
    if type(db1) == "userdata" or type(db1) == "cdata" then
        promise.thread.data = db1
        if db2 then
            promise.thread.buffer = tostring(db2)
        end
    elseif db1 then
        promise.thread.buffer = tostring(db1)
        if type(db2) == "userdata" or type(db2) == "cdata" then
            promise.thread.data = db2
        end
    elseif db2 then
        if type(db2) == "userdata" or type(db2) == "cdata" then
            promise.thread.data = db2
        else
            promise.thread.buffer = tostring(db2)
        end
    end
    promise.thread:run()

    function promise.await()
        while promise.thread.running do
            sleep(0)
        end
        return promise.thread.buffer
    end

    function promise.running()
        return promise.thread.running
    end

    function promise.result()
        return promise.thread.buffer
    end

    return promise
end